﻿/*****************************************************************************************************
* $$FileName		Update Images.jsx
*
* $$Description		Sample ExtendScript file to change the image file extension in any project, Plesae see the GetUpdatedImageName function
*
* Copyright (c) 2009 Adobe Systems Incorporated. All Rights Reserved.
******************************************************************************************************/

//global variables
main();

function main()
{
	var topicmanager = RoboHelp.project.TopicManager;
	var topic;
	for(var index=1;index<=topicmanager.count;index++)
	{
		topic = topicmanager.item(index);
		//we need update the topic now.
		UpdateFileImages(topic.path);
	}

	var snippetmanager = RoboHelp.project.SnippetManager;
	var snippet;
	for(var index=1;index<=snippetmanager.count;index++)
	{
		snippet = snippetmanager.item(index);
		//we need update the topic now.
		UpdateFileImages(snippet.path);
	}

}

function outputMsg(szString)
{
	RoboHelp.project.outputMessage (szString);
}


function UpdateFileImages(filepath)
{
	var msg = 'Reading File '+filepath+'\n';
	outputMsg(msg);
	
	//this is to get the token manager for the topic specified.
	var tokenmgr = RoboHelp.getTokenManager(filepath);
	var bSave = false;
	if(typeof(tokenmgr)!='undefined')
	{
		if(tokenmgr.count>0)
		{
			var token = tokenmgr.item(1);
			while(typeof(token)!='undefined')
			{
				msg = 'Token = '+token.name+' ('+token.tokenType+') '+'\n';
				outputMsg (msg);
				//we have the token we need to check if this is the one we are worried about
				if(token.tokenType ==RoboHelp.TokenType.TOKENTAG && token.tagType==RoboHelp.TagType.TAGIMAGE)
				{
					msg = 'Reset image'+ '\n';
					outputMsg (msg);
					
					token.removeAttribute('width');
					token.removeAttribute('height');
					bSave = true;
				}
				token = token.next;
			}
		}
		if(bSave)
		{
			tokenmgr.save();
			msg = 'Saving File '+filepath+'\n';
			outputMsg (msg);
		}
	}
}

